/*
 * Decompiled with CFR 0.152.
 */
package icommand.robotics;

import icommand.platform.nxt.Motor;
import icommand.platform.nxt.SyncMotors;
import icommand.robotics.Navigator;

public class ServoNavigator
implements Navigator {
    private double angle;
    private float x;
    private float y;
    private SyncMotors vehicle;
    private double COUNTS_PER_CM;
    private double COUNTS_PER_DEGREE;
    private boolean moving;

    public ServoNavigator(double d, double d2, SyncMotors syncMotors) {
        this(d, d2, 360.0, syncMotors);
    }

    public ServoNavigator(double d, double d2, double d3, SyncMotors syncMotors) {
        this.vehicle = syncMotors;
        this.angle = 0.0;
        this.x = 0.0f;
        this.y = 0.0f;
        this.moving = false;
        double d4 = d / 10.0 * Math.PI;
        this.COUNTS_PER_CM = d3 / d4;
        this.COUNTS_PER_DEGREE = this.COUNTS_PER_CM * (Math.PI * 2 * d2 / 360.0);
    }

    public ServoNavigator(float f, float f2, float f3, Motor motor, Motor motor2) {
        this(f, f2, f3, new SyncMotors(motor, motor2));
    }

    public float getX() {
        if (this.moving) {
            double d = (double)this.vehicle.left.getBlockTacho() / this.COUNTS_PER_CM;
            return this.x + (float)(Math.cos(Math.toRadians(this.getAngle())) * d);
        }
        return this.x;
    }

    public float getY() {
        if (this.moving) {
            double d = (double)this.vehicle.left.getBlockTacho() / this.COUNTS_PER_CM;
            return this.y + (float)(Math.sin(Math.toRadians(this.getAngle())) * d);
        }
        return this.y;
    }

    public double getAngle() {
        return this.angle;
    }

    public void rotate(double d) {
        this.angle += d;
        this.angle = (int)this.angle % 360;
        while (this.angle < 0.0) {
            this.angle += 360.0;
        }
        int n = (int)(this.COUNTS_PER_DEGREE * d);
        if (d > 0.0) {
            this.vehicle.left(n, false);
        } else if (d < 0.0) {
            this.vehicle.right(Math.abs(n), false);
        }
    }

    public void rotateBackwards(double d) {
        this.angle += d;
        this.angle = (int)this.angle % 360;
        while (this.angle < 0.0) {
            this.angle += 360.0;
        }
        int n = (int)(this.COUNTS_PER_DEGREE * d);
        this.vehicle.invertMotors();
        if (d > 0.0) {
            this.vehicle.left(n, false);
        } else if (d < 0.0) {
            this.vehicle.right(Math.abs(n), false);
        }
        this.vehicle.invertMotors();
    }

    public void gotoAngle(double d) {
        double d2;
        for (d2 = d - this.angle; d2 > 180.0; d2 -= 360.0) {
        }
        while (d2 < -180.0) {
            d2 += 360.0;
        }
        this.rotate(d2);
    }

    public void gotoPoint(double d, double d2) {
        double d3 = d - (double)this.x;
        double d4 = d2 - (double)this.y;
        float f = (float)Math.atan2(d4, d3);
        double d5 = d4 != 0.0 ? d4 / Math.sin(f) : d3 / Math.cos(f);
        f = (float)Math.toDegrees(f);
        this.gotoAngle(f);
        this.travel(Math.round(d5));
    }

    public void travel(long l) {
        int n = (int)((double)l * this.COUNTS_PER_CM);
        this.moving = true;
        if (l > 0L) {
            this.vehicle.forward(Math.abs(n));
        } else if (l < 0L) {
            this.vehicle.backward(Math.abs(n));
        }
        this.moving = false;
        this.recalculate();
    }

    public void forward() {
        this.vehicle.forward();
        this.moving = true;
    }

    public void backward() {
        this.vehicle.backward();
        this.moving = true;
    }

    public void stop() {
        if (this.moving) {
            this.vehicle.stop();
            this.recalculate();
        }
    }

    private void recalculate() {
        int n = (this.vehicle.left.getBlockTacho() + this.vehicle.right.getBlockTacho()) / 2;
        double d = (double)n / this.COUNTS_PER_CM;
        this.x += (float)(Math.cos(Math.toRadians(this.angle)) * d);
        this.y += (float)(Math.sin(Math.toRadians(this.angle)) * d);
    }
}

