/*
 * Decompiled with CFR 0.152.
 */
package icommand.vision;

import icommand.vision.Font;
import icommand.vision.MotionDetectionControl;
import icommand.vision.MotionListener;
import icommand.vision.Region;
import icommand.vision.Vision;
import icommand.vision.VisionEffect;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class MotionDetectionEffect
extends VisionEffect {
    private int[] blobCount = new int[Region.MAX_REGIONS];
    public int OPTIMIZATION = 0;
    public int THRESHOLD_MAX = 10000;
    public int THRESHOLD_INC = 1000;
    public int THRESHOLD_INIT = 1000;
    private byte[] refData;
    private byte[] bwData;
    private int avg_ref_intensity;
    private int avg_img_intensity;
    public int threshold = 10;
    public int blob_threshold = this.THRESHOLD_INIT;
    public boolean debug = false;
    private Control[] controls;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int process(Buffer buffer, Buffer buffer2) {
        int n;
        int n2;
        int n3;
        int n4 = ((VideoFormat)this.outputFormat).getMaxDataLength();
        this.validateByteArraySize(buffer2, n4);
        buffer2.setLength(n4);
        buffer2.setFormat(this.outputFormat);
        buffer2.setFlags(buffer.getFlags());
        byte[] byArray = (byte[])buffer.getData();
        byte[] byArray2 = (byte[])buffer2.getData();
        RGBFormat rGBFormat = (RGBFormat)buffer.getFormat();
        Dimension dimension = rGBFormat.getSize();
        int n5 = rGBFormat.getPixelStride();
        int n6 = rGBFormat.getLineStride();
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (Vision.takeSnapshot()) {
            try {
                Vision.writeImage(Vision.snapshotFilename, byArray, Vision.imageWidth, Vision.imageHeight);
            }
            catch (Exception exception) {
                System.out.println("Failed to take snapshot");
            }
            finally {
                Vision.setSnapshot(false);
            }
        }
        if (this.refData == null) {
            this.refData = new byte[n4];
            this.bwData = new byte[n4];
            System.arraycopy(byArray, 0, this.refData, 0, byArray.length);
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            for (int i = 0; i < n4; ++i) {
                n7 += this.refData[i] & 0xFF;
            }
            this.avg_ref_intensity = n7 / n4;
            return 0;
        }
        if (byArray2.length < dimension.width * dimension.height * 3) {
            System.out.println("the buffer is not full");
            return 1;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            n7 += byArray[n3] & 0xFF;
        }
        this.avg_img_intensity = n7 / n4;
        int n10 = this.avg_ref_intensity < this.avg_img_intensity ? this.avg_img_intensity - this.avg_ref_intensity : this.avg_ref_intensity - this.avg_img_intensity;
        this.avg_ref_intensity = this.avg_img_intensity;
        int n11 = 0;
        n3 = 0;
        for (int i = 0; i < n4 / n5; ++i) {
            byte by;
            n8 = this.refData[n3] & 0xFF;
            int n12 = n8 > (n9 = byArray[n3++] & 0xFF) ? n8 - n9 : n9 - n8;
            n8 = this.refData[n3] & 0xFF;
            n9 = byArray[n3++] & 0xFF;
            int n13 = n8 > n9 ? n8 - n9 : n9 - n8;
            n8 = this.refData[n3] & 0xFF;
            n9 = byArray[n3++] & 0xFF;
            int n14 = n8 > n9 ? n8 - n9 : n9 - n8;
            if ((by = (byte)Math.sqrt((double)((n12 -= n12 < n10 ? n12 : n10) * n12 + (n13 -= n13 < n10 ? n13 : n10) * n13 + (n14 -= n14 < n10 ? n14 : n10) * n14) / 3.0)) > (byte)this.threshold) {
                this.bwData[n11++] = -1;
                this.bwData[n11++] = -1;
                this.bwData[n11++] = -1;
                continue;
            }
            this.bwData[n11++] = by;
            this.bwData[n11++] = by;
            this.bwData[n11++] = by;
        }
        Region[] regionArray = Vision.getRegions();
        for (n2 = 0; n2 < regionArray.length; ++n2) {
            this.blobCount[n2] = 0;
        }
        for (n11 = n6 + 3; n11 < n4 - n6 - 3; n11 += 3) {
            for (n2 = 0; n2 < 1 && (this.bwData[n11 + 2] & 0xFF) >= 255 && (this.bwData[n11 + 2 - n6] & 0xFF) >= 255 && (this.bwData[n11 + 2 + n6] & 0xFF) >= 255 && (this.bwData[n11 + 2 - 3] & 0xFF) >= 255 && (this.bwData[n11 + 2 + 3] & 0xFF) >= 255 && (this.bwData[n11 + 2 - n6 + 3] & 0xFF) >= 255 && (this.bwData[n11 + 2 - n6 - 3] & 0xFF) >= 255 && (this.bwData[n11 + 2 + n6 - 3] & 0xFF) >= 255 && (this.bwData[n11 + 2 + n6 + 3] & 0xFF) >= 255; ++n2) {
                this.bwData[n11] = 0;
                this.bwData[n11 + 1] = 0;
                int n15 = n11 / n6;
                n = n11 % n6 / n5;
                for (int i = 0; i < Region.MAX_REGIONS; ++i) {
                    if (regionArray[i] == null || !regionArray[i].inRegion(n, n15)) continue;
                    int n16 = i;
                    this.blobCount[n16] = this.blobCount[n16] + 1;
                }
            }
        }
        for (n2 = 0; n2 < Region.MAX_REGIONS && regionArray[n2] != null; ++n2) {
            if (this.blobCount[n2] <= this.blob_threshold) continue;
            MotionListener[] motionListenerArray = regionArray[n2].getMotionListeners();
            for (n = 0; n < motionListenerArray.length; ++n) {
                motionListenerArray[n].motionDetected(n2 + 1);
            }
            if (this.debug) {
                this.sample_down(byArray, byArray2, 0, 0, dimension.width, dimension.height, n6, n5);
                Font.println("original picture", 1, 0, 0, (byte)-1, (byte)-1, (byte)-1, buffer2);
                this.sample_down(this.refData, byArray2, 0, dimension.height / 2, dimension.width, dimension.height, n6, n5);
                Font.println("reference picture", 1, 0, dimension.height, (byte)-1, (byte)-1, (byte)-1, buffer2);
                this.sample_down(this.bwData, byArray2, dimension.width / 2, 0, dimension.width, dimension.height, n6, n5);
                Font.println("motion detection pic", 1, dimension.width / 2, 0, (byte)-1, (byte)-1, (byte)-1, buffer2);
            } else {
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            }
            System.arraycopy(byArray, 0, this.refData, 0, byArray.length);
            return 0;
        }
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return 0;
    }

    public String getName() {
        return "Motion Detection Effect";
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new MotionDetectionControl(this);
        }
        return this.controls;
    }

    void sample_down(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = 0; i < n4 / 2; ++i) {
            int n7 = i * 2 * n5;
            int n8 = n7 + n6;
            int n9 = n7 + n5;
            int n10 = n9 + n6;
            int n11 = n5 * i + n5 * n2 + n * n6;
            for (int j = 0; j < n3 / 2; ++j) {
                byArray2[n11++] = (byte)(((byArray[n7++] & 0xFF) + (byArray[n8++] & 0xFF) + (byArray[n9++] & 0xFF) + (byArray[n10++] & 0xFF)) / 4);
                byArray2[n11++] = (byte)(((byArray[n7++] & 0xFF) + (byArray[n8++] & 0xFF) + (byArray[n9++] & 0xFF) + (byArray[n10++] & 0xFF)) / 4);
                byArray2[n11++] = (byte)(((byArray[n7++] & 0xFF) + (byArray[n8++] & 0xFF) + (byArray[n9++] & 0xFF) + (byArray[n10++] & 0xFF)) / 4);
                n7 += 3;
                n8 += 3;
                n9 += 3;
                n10 += 3;
            }
        }
    }
}

