/*
 * Decompiled with CFR 0.152.
 */
package icommand.vision;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Effect;
import javax.media.Format;
import javax.media.format.RGBFormat;

public abstract class VisionEffect
implements Effect {
    protected Format inputFormat;
    protected Format outputFormat;
    protected Format[] inputFormats = new Format[]{new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, 3, 2, 1, 3, -1, 1, -1)};
    protected Format[] outputFormats = new Format[]{new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, 3, 2, 1, 3, -1, 1, -1)};

    public Format[] getSupportedInputFormats() {
        return this.inputFormats;
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.outputFormats;
        }
        if (this.matches(format, this.inputFormats) != null) {
            return new Format[]{this.outputFormats[0].intersects(format)};
        }
        return new Format[0];
    }

    public Format setInputFormat(Format format) {
        this.inputFormat = format;
        return format;
    }

    public Format setOutputFormat(Format format) {
        if (format == null || this.matches(format, this.outputFormats) == null) {
            return null;
        }
        RGBFormat rGBFormat = (RGBFormat)format;
        Dimension dimension = rGBFormat.getSize();
        int n = rGBFormat.getMaxDataLength();
        int n2 = rGBFormat.getLineStride();
        float f = rGBFormat.getFrameRate();
        if (dimension == null) {
            return null;
        }
        if (n < dimension.width * dimension.height * 3) {
            n = dimension.width * dimension.height * 3;
        }
        if (n2 < dimension.width * 3) {
            n2 = dimension.width * 3;
        }
        this.outputFormat = this.outputFormats[0].intersects((Format)new RGBFormat(dimension, n, null, f, -1, -1, -1, -1, -1, n2, -1, -1));
        return this.outputFormat;
    }

    public void open() {
    }

    public void close() {
    }

    public void reset() {
    }

    public Object getControl(String string) {
        return null;
    }

    public Object[] getControls() {
        return null;
    }

    protected Format matches(Format format, Format[] formatArray) {
        for (int i = 0; i < formatArray.length; ++i) {
            if (!format.matches(formatArray[i])) continue;
            return formatArray[i];
        }
        return null;
    }

    protected byte[] validateByteArraySize(Buffer buffer, int n) {
        byte[] byArray;
        Object object = buffer.getData();
        if (object instanceof byte[]) {
            byArray = (byte[])object;
            if (byArray.length >= n) {
                return byArray;
            }
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray = byArray2;
        } else {
            byArray = new byte[n];
        }
        buffer.setData((Object)byArray);
        return byArray;
    }
}

