import icommand.platform.nxt.*;
import icommand.nxtcomm.*;
import icommand.robotics.*;

public class UltrasonicTest {

	public static void usage() {
		System.out.println("Usage:");
		System.out.println("  java UltrasonicTest <speed> <distance>");
		System.out.println("");
		System.out.println("     speed:     Integeger between 1 and 255");
		System.out.println("     distance:  Integeger between 10 and 60");
	}

	public static void main(String[] args) {
		if(args.length < 2) {
			usage();
			return;
		}

		int speed = Integer.parseInt(args[0]);
		int distance = Integer.parseInt(args[1]);

        if(distance < 10)
            distance = 10;
        if(distance > 60)
            distance = 60;

		SyncMotors sm = new SyncMotors(Motor.C, Motor.B);
		sm.setSpeed(speed);
		sm.forward();

		Ultrasonic us = new Ultrasonic(Sensor.S4);

		int d = us.getDistance();
		long start = System.currentTimeMillis();
		for(int i=0; i<99; i++) {
			System.currentTimeMillis();
		}

		System.out.println("Für den Aufruf von 100x System.currentTimeMillis() benötigte Zeit: " + (System.currentTimeMillis() - start));

		System.out.println("Ab jetzt: Messung der Aufrufdauer von us.getDistance():");
		start = System.currentTimeMillis();
		while(d > distance) {
			d = us.getDistance();
			System.out.println("Benötigte Zeit: " + (System.currentTimeMillis()-start) + "ms, zurückgegebener Wert: " + d);
			start = System.currentTimeMillis();
		}

		sm.stop();

	        NXTCommand.close();
	}
}

