{******************************************************************************
 *  pic.pp - reprogram the PIC
 *
 *
 *  Copyright (c) 2004 nucleOS Group [http://nucle-os.sourceforge.net/]
 *                                   [http://www.sf.net/projects/nucle-os]
 *                                   [http://www.saint-soft.de/nucleos/board/]
 *
 *  version 0.1 - 13/03/04 - first release
 *
 *  written by
 *    Bastian Gloeckle (MrSaint) [admin@saint-soft.de]
 *
 *  This file does
 *   - reprogram the PIC ;)
 *
 * This program is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software Foundation
 * (version 2, June 1991)
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program; if not, write to:
 * Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330
 * Boston, MA 02111-1307 USA
 *
 ******************************************************************************}

unit pic;

interface

uses ports;

procedure program_PIC(bPIC1, bPIC2: byte);

implementation

{ see http://mega-tokyo.com/os/os-faq-pics.html#remap_pic }

const	PIC1		= $20;
        PIC2		= $A0;

procedure program_PIC(bPIC1, bPIC2: byte); [public, alias: 'PROGRAM_PIC'];
var save1, save2: byte;

  procedure wait; assembler;
  asm
     nop
     nop
     nop
  end;

begin

asm
    mov   al , 17
    out   20h, al
    nop
    nop
    nop
    out   $A0, al
    nop
    nop
    nop
    mov   al , 28h
    out   21h, al
    nop
    nop
    nop
    mov   al , 30h
    out  0A1h, al
    nop
    nop
    nop
    mov   al , 4
    out   21h, al
    nop
    nop
    nop
    mov   al , 2
    out  0A1h, al
    nop
    nop
    nop
    mov   al , 1
    out   21h, al
    nop
    nop
    nop
    out  0A1h, al
    nop
    nop
    nop

    mov   al , 0FEh               
    out   21h, al
    mov   al , 0FFh               
    out  0A1h, al
end;
exit;

  save1 := pinb(PIC1+1);
  save2 := pinb(PIC2+1);

  poutb(PIC1, $11);
  poutb(PIC2, $11);
  poutb(PIC1+1, bPIC1);
  poutb(PIC2+1, bPIC2);

  poutb(PIC1+1, 4);
  poutb(PIC2+1, 2);

  poutb(PIC1+1, $1);
  poutb(PIC2+1, $1);

  poutb(PIC1+1, $FC);
  poutb(PIC2+1, $FF);
end;

begin
end.

