/***************************************************************************
 *   Copyright (C) 2008 by Michael Gerhäuser   *
 *   michael.gerhaeuser@gmx.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "operators.h"

void init_operators() {
    srand( time(NULL) );
}

/* Ein-Punkt-Crossover */
void rekombination(MY_DATA * vater, MY_DATA * mutter, MY_DATA * kind) {
    int pos = rand()%(RELEVANT_BITS);
    MY_DATA tmp_kind = 0;
    MY_DATA t_vater, t_mutter;

    for(int j=0; j<2; j++) {
        t_vater = encodeGray(vater[j]);
        t_mutter = encodeGray(mutter[j]);

        tmp_kind = 0;
        for(int i=0; i<pos; i++) {
            setBit(&tmp_kind, i, isBitSet(t_vater, i));
        }
        for(int i=pos; i<RELEVANT_BITS; i++) {
            setBit(&tmp_kind, i, isBitSet(t_mutter, i));
        }
        kind[j] = decodeGray(tmp_kind);
    }

    return;
}

void mutation(MY_DATA * individuum) {
    int mutiere;
    int tmp;

    for(int j=0; j<2; j++) {
        tmp = encodeGray(individuum[j]);

        for(int i=0; i<RELEVANT_BITS; i++) {
            mutiere = rand()%1000;
            if(mutiere >= 1000-4*RELEVANT_BITS+4*i) {
                setBit(&tmp, i, !isBitSet(tmp, i));
            }
        }

        individuum[j] = decodeGray(tmp);
    }

    return;
}

void sortiere(MY_DATA * ziel, int * index, int length) {
    int tmp_i = 0;
    MY_DATA tmp_d = 0.;

    for(int j=length; j>0; j--) {
        for(int i=0; i<j-1; i++) {
            if((REAL_DATA)(ziel[i]) > (REAL_DATA)(ziel[i+1])) {
                tmp_d = ziel[i];
                ziel[i] = ziel[i+1];
                ziel[i+1] = tmp_d;

                tmp_i = index[i];
                index[i] = index[i+1];
                index[i+1] = tmp_i;
            }
        }
    }
}

void selektion(MY_DATA ** population, int groesse, MY_DATA ** kinder, int anzahl_kinder, MY_DATA * target, int * indizes) {
    sortiere(target, indizes, anzahl_kinder+groesse);

    MY_DATA ** backup = new MY_DATA*[groesse];
    for(int i=0; i<groesse; i++) {
        backup[i] = new MY_DATA[2];
        backup[i][0] = population[i][0];
        backup[i][1] = population[i][1];
    }

    for(int i=0; i<groesse; i++) {
        if(indizes[i] < groesse) {
            population[i][0] = backup[indizes[i]][0];
            population[i][1] = backup[indizes[i]][1];
        } else {
            population[i][0] = kinder[indizes[i]-groesse][0];
            population[i][1] = kinder[indizes[i]-groesse][1];
        }
    }

    for(int i=0; i<groesse; i++) {
        delete [] backup[i];
    }
    delete [] backup;

    return;
}

void erzeuge_individuum(MY_DATA * individuum) {
    bool set = false;
    for(int j=0; j<2; j++) {
        for(int i=0; i<RELEVANT_BITS; i++) {
            set = ( (rand()%(3)) == 1 );
            setBit(&individuum[j], i, set);
            individuum[j] = decodeGray(individuum[j]);
        }
    }
}

void erzeuge_adam_und_eva(MY_DATA ** population, int groesse) {
    for(int i=0; i<groesse; i++) {
        erzeuge_individuum(population[i]);
    }
}

void erzeuge_naechste_generation(MY_DATA ** population, int groesse, MY_DATA ** kinder_generation, int anzahl_kinder) {
    int vater = 0, mutter = 0;
    MY_DATA * kind = new MY_DATA[2];

    for(int i=0; i<groesse; i++) {
        mutation(population[i]);
    }

    for(int i=0; i<anzahl_kinder; i++) {
        vater = rand()%groesse;
        mutter = rand()%groesse;
        rekombination(population[vater], population[mutter], kind);
        mutation(kind);
        kinder_generation[i][0] = kind[0];
        kinder_generation[i][1] = kind[1];
    }

    delete [] kind;
}

void population_speichern(MY_DATA ** population, int groesse, string filename) {
    ofstream datei;
    datei.open(filename.c_str());

    for(int i=0; i<groesse; i++) {
        datei << (REAL_DATA)(population[i][0]/SCALE) << "\t" << (REAL_DATA)(population[i][1]/SCALE) << endl;
    }

    datei.close();
}
