clear all;
close all;

number = 2; % = count/20
count = 40;

figure(1);

    fid = fopen('data/avfitness', 'r');
    a = fscanf(fid, '%g', [inf]);
    a = a';
    fclose(fid);
    t = 40/size(a,2):40/size(a,2):40;

    plot(t(1, :), a(1, :), '-r', 'LineWidth', 3);
    xlabel('Generation');
    ylabel('Durchschnittliche Fitness einer Generation');
    axis tight;
    grid on;
%    print('-dpng', 'plot_fitness.png')

%    set(gcf, 'PaperType', 'A1');
%    orient landscape
%    print('-dpdf', 'plot_fitness.pdf')

figure(2);
    i = 0;

    disp(['data/generation_', num2str(i)]);
    fid = fopen(['data/generation_', num2str(i)], 'r');
    a = fscanf(fid, '%g %g', [2 inf]);
    a = a';
    fclose(fid);

    plot(a(:, 1), a(:, 2), '*');
    title(['Generation ', num2str(i)]);
    axis tight;
    grid on;

 %   set(gcf, 'PaperType', 'A1');
 %   orient landscape
 %   print('-dpdf', 'plot_gen0.pdf')

figure(3);

    for i=number:number:20*number
        disp(['data/generation_', num2str(i)]);
        fid = fopen(['data/generation_', num2str(i)], 'r');
        a = fscanf(fid, '%g %g', [2 inf]);
        a = a';
        fclose(fid);

        subplot(4, 5, i/number);
        plot(a(:, 1), a(:, 2), '*');
        title(['Generation ', num2str(i)]);
        axis tight;
        grid on;
    end

%     set(gcf, 'PaperType', 'A1');
%     orient landscape
%     print('-dpdf', 'plot.pdf')

figure(4);

    [X,Y] = meshgrid(10:1:90);

    hold on;

    % Ebene auf Hhe 0
    %Z = 0*X;
    %mesh(X,Y,Z);

    % Zielfunktion
    %Z = sin(X)+sin(Y);
    %Z = (X-50).*(X-50)+(Y-50).*(Y-50);
    Z = (X-25).*(X-75).*(X-50).*(X-50)+(Y-25).*(Y-75).*(Y-50).*(Y-50)
    %Z = 2+X./3.*sin((3*pi)/105 .* X) + Y./3.*cos((6*pi)/105 .* Y);

    % Ebene auf Hoehe -47
    plane = -47*ones(size(a,1),1);

    mesh(X,Y,Z);
    axis tight;
    grid on;
    view(45,15);
    hidden off
    shading faceted

    %print('-dpng', 'zielfunktion.png')

    for i=0:1:count
        disp(['data/generation_', num2str(i)]);
        fid = fopen(['data/generation_', num2str(i)], 'r');
        a = fscanf(fid, '%g %g', [2 inf]);
        a = a';
        fclose(fid);

        mesh(X,Y,Z);
        hold on;
        plot3(a(:, 1), a(:, 2), plane, '*r');
        title(['Generation ', num2str(i)]);
        axis tight;
        grid on;
        view(45,15);
        hidden off
        shading faceted

        hold off;

        pause;

%    print('-dpng', ['generation_', num2str(i)])
    end
