/*
 * Decompiled with CFR 0.152.
 */
package icommand.platform.nxt;

import icommand.nxtcomm.NXTCommand;
import icommand.platform.nxt.Sensor;

public class I2CSensor {
    protected static byte DEFAULT_ADDRESS = (byte)2;
    protected static byte STOP = 0;
    protected static byte VERSION = 0;
    protected static byte PRODUCT_ID = (byte)8;
    protected static byte SENSOR_TYPE = (byte)16;
    byte port;

    public I2CSensor(Sensor sensor, byte by) {
        this.port = (byte)sensor.getId();
        sensor.setTypeAndMode(by, 0);
        NXTCommand.LSGetStatus(this.port);
        NXTCommand.LSRead(this.port);
    }

    public int getId() {
        return this.port;
    }

    protected byte[] getData(byte by, int n) {
        byte[] byArray;
        byte[] byArray2 = new byte[]{DEFAULT_ADDRESS, by};
        NXTCommand.LSWrite(this.port, byArray2, (byte)n);
        while ((byArray = NXTCommand.LSGetStatus(this.port))[0] == 32 | byArray[0] == -32) {
        }
        if (byArray[1] == 0) {
            System.out.println("No bytes to be read in I2CSensor.getData(). Returning 0.");
            return new byte[1];
        }
        byte[] byArray3 = NXTCommand.LSRead(this.port);
        return byArray3;
    }

    protected byte getData(byte by) {
        return this.getData(by, 1)[0];
    }

    protected void setData(byte by, byte by2) {
        byte[] byArray = new byte[]{DEFAULT_ADDRESS, by, by2};
        NXTCommand.LSWrite(this.port, byArray, (byte)0);
    }

    public String getVersion() {
        return this.fetchString(VERSION, 8);
    }

    public String getProductID() {
        return this.fetchString(PRODUCT_ID, 8);
    }

    public String getSensorType() {
        return this.fetchString(SENSOR_TYPE, 8);
    }

    protected String fetchString(byte by, int n) {
        byte[] byArray = this.getData(by, n);
        int n2 = 0;
        for (n2 = 0; n2 < byArray.length && byArray[n2] != 0; ++n2) {
        }
        String string = new String(byArray).substring(0, n2);
        return string;
    }
}

