import icommand.platform.nxt.*;
import icommand.nxtcomm.*;
import icommand.robotics.*;

public class TouchTest {

	public static void usage() {
		System.out.println("Usage:");
		System.out.println("  java TouchTest <duration>");
		System.out.println("");
		System.out.println("     duration:     Integeger between 1 and 30");
	}

	public static void main(String[] args) {
		if(args.length < 1) {
			usage();
			return;
		}

		int duration = Integer.parseInt(args[0]);
		if(duration > 30)
			duration = 30;
		duration = duration * 1000;

		Touch t = new Touch(Sensor.S1);

		boolean touched = t.isPressed();
		long start = System.currentTimeMillis();
		for(int i=0; i<99; i++) {
			System.currentTimeMillis();
		}

		System.out.println("Für den Aufruf von 100x System.currentTimeMillis() benötigte Zeit: " + (System.currentTimeMillis() - start));

		System.out.println("Ab jetzt: Messung der Aufrufdauer von Touch.isPressed():");
		start = System.currentTimeMillis();
		long last_time = System.currentTimeMillis();
		while(System.currentTimeMillis() - start < duration) {
			touched = t.isPressed();
			System.out.println("Benötigte Zeit: " + (System.currentTimeMillis()-last_time) + "ms, zurückgegebener Wert: " + touched);
			last_time = System.currentTimeMillis();
		}

	        NXTCommand.close();
	}
}

