/*
 * Decompiled with CFR 0.152.
 */
package icommand.platform.nxt;

import icommand.platform.nxt.Motor;

public class SyncMotors {
    public Motor left;
    public Motor right;
    boolean inverted;
    boolean sync;

    public SyncMotors(Motor motor, Motor motor2) {
        this.left = motor;
        this.right = motor2;
        this.inverted = false;
        this.setSync(true);
    }

    public void setSpeed(int n) {
        this.left.setSpeed(n);
        this.right.setSpeed(n);
    }

    public void invertMotors() {
        this.inverted = !this.inverted;
    }

    public void setSync(boolean bl) {
        if (this.sync != bl) {
            this.sync = bl;
            if (bl) {
                this.left.setRegulationMode(2);
                this.right.setRegulationMode(2);
            } else {
                this.left.setRegulationMode(0);
                this.right.setRegulationMode(0);
            }
        }
    }

    public void forward() {
        this.setSync(true);
        this.left.resetBlockTacho();
        this.right.resetBlockTacho();
        this.left.turnRatio = 0;
        this.right.turnRatio = 0;
        if (this.inverted) {
            this.left.backward();
            this.right.backward();
        } else {
            this.left.forward();
            this.right.forward();
        }
    }

    public void backward() {
        this.setSync(true);
        this.left.resetBlockTacho();
        this.right.resetBlockTacho();
        this.left.turnRatio = 0;
        this.right.turnRatio = 0;
        if (this.inverted) {
            this.left.forward();
            this.right.forward();
        } else {
            this.left.backward();
            this.right.backward();
        }
    }

    public void left() {
        this.setSync(false);
        this.left.resetBlockTacho();
        this.right.resetBlockTacho();
        if (this.inverted) {
            this.left.backward();
        } else {
            this.right.forward();
        }
    }

    public void right() {
        this.setSync(false);
        this.left.resetBlockTacho();
        this.right.resetBlockTacho();
        if (this.inverted) {
            this.right.backward();
        } else {
            this.left.forward();
        }
    }

    public void left(long l) {
        this.left(l, false);
    }

    public void left(long l, boolean bl) {
        this.setSync(false);
        this.left.resetBlockTacho();
        this.right.resetBlockTacho();
        this.left.resetRotationCounter();
        this.right.resetRotationCounter();
        if (this.inverted) {
            this.left.backward(l, bl);
        } else {
            this.right.forward(l, bl);
        }
    }

    public void right(long l) {
        this.right(l, false);
    }

    public void right(long l, boolean bl) {
        this.setSync(false);
        this.left.resetBlockTacho();
        this.right.resetBlockTacho();
        this.left.resetRotationCounter();
        this.right.resetRotationCounter();
        if (this.inverted) {
            this.right.backward(l, bl);
        } else {
            this.left.forward(l, bl);
        }
    }

    public void forward(long l) {
        this.setSync(true);
        this.left.resetBlockTacho();
        this.right.resetBlockTacho();
        this.left.turnRatio = 0;
        this.right.turnRatio = 0;
        if (this.inverted) {
            this.left.backward(l, true);
            this.right.backward(l, true);
        } else {
            this.left.forward(l, true);
            this.right.forward(l, true);
        }
        while ((long)Math.abs(this.left.getBlockTacho()) < l) {
        }
    }

    public void backward(long l) {
        this.setSync(true);
        this.left.resetBlockTacho();
        this.right.resetBlockTacho();
        this.left.turnRatio = 0;
        this.right.turnRatio = 0;
        if (this.inverted) {
            this.left.forward(l, true);
            this.right.forward(l, true);
        } else {
            this.left.backward(l, true);
            this.right.backward(l, true);
        }
        while ((long)Math.abs(this.left.getBlockTacho()) < l) {
        }
    }

    public void stop() {
        this.setSync(false);
        this.left.stop();
        this.right.stop();
    }

    public void flt() {
        this.setSync(false);
        this.left.flt();
        this.right.flt();
    }
}

