import icommand.platform.nxt.*;
import icommand.nxtcomm.*;
import icommand.robotics.*;

public class Rotate {

	public static void usage() {
		System.out.println("Usage:");
		System.out.println("  java Rotate <speed> <degrees>");
		System.out.println("");
		System.out.println("     speed:     Integeger between 1 and 255");
		System.out.println("     degrees:   Degrees in °");
	}

	public static void main(String[] args) {
		if(args.length < 2) {
			usage();
			return;
		}

		int speed = Integer.parseInt(args[0]);
		int degrees = Integer.parseInt(args[1]);

		SyncMotors sm = new SyncMotors(Motor.C, Motor.B);
		sm.setSpeed(speed);
		ServoNavigator sn = new ServoNavigator(56.0, 11.5, 360.0, sm);
		sn.rotate(degrees);

        NXTCommand.close();
	}
}

