import icommand.platform.nxt.*;
import icommand.nxtcomm.*;
import icommand.robotics.*;

public class Forward {

	public static void usage() {
		System.out.println("Usage:");
		System.out.println("  java Forward <speed> <distance>");
		System.out.println("");
		System.out.println("     speed:     Integeger between 1 and 255");
		System.out.println("     distance:  Distance in cm");
	}

	public static void main(String[] args) {
		if(args.length < 2) {
			usage();
			return;
		}

		int speed = Integer.parseInt(args[0]);
		int distance = Integer.parseInt(args[1]);

		SyncMotors sm = new SyncMotors(Motor.C, Motor.B);
		sm.setSpeed(speed);
		ServoNavigator sn = new ServoNavigator(56.0, 11.5, 360.0, sm);
		sn.travel(distance);

	        NXTCommand.close();
	}
}

