#include <stdio.h>
#include <stdlib.h>

// Header von javah -jni erstellt
#include "jdummy.h"

/*
 * FORTRAN Funktionen muessen als extern deklariert werden
 * Parameter werden als call-by-reference uebergeben
 * Damit die Funktion in der Library gefunden wird, muss ein "_" angehaengt werden
 */
//                               = int *, = double *
extern void fcn_(int *, double *, int [], double [], int *, double *);

/*
 * Um eine C-Funktion von Java aus aufzurufen, muss ihr Name wie folgt zusammengesetzt werden:
 *   "Java_" + Name der Klasse, die den C-Code aufruft + "_" + Name der Funktion
 * in diesem Fall:
 *   Java_jdummy_cdummy
 *
 * Die ersten beiden Parameter muessen immer uebergeben werden, der Rest variiert nach Bedarf,
 * was man eben vom Java-Programm aus uebergeben will.
 * Diese Deklaration kann man meist aus dem von javah erzeugten Headerfile kopieren
 */

JNIEXPORT void JNICALL Java_jdummy_cdummy
   (JNIEnv *env, jobject jobj,                       // Standard Parameter, muessen bei jedem Aufruf uebergeben werden
    jint ji, jdouble jd,                             // Skalare Parameter
    jintArray ji_a, jdoubleArray jd_a,               // Vektoren
    jobjectArray ji_2a, jobjectArray jd_2a           // Die 2-dimensionalen Arrays (/ Matrizen)
   ) {

    printf("C: -- Ab jetzt: C --\n");

    //  Die Daten aus Java holen

    // Erst die Eindimensionalen Arrays
    jsize n = ji;
    jint *i_a = (*env)->GetIntArrayElements(env, ji_a, 0);
    jdouble *d_a = (*env)->GetDoubleArrayElements(env, jd_a, 0);

    jsize i, j;

    // Die lokalen Arrays initialisieren
    int imat[n][n];
    double dmat[n][n];

    // Nun die 2-dimensionalen Arrays
    for(i=0; i<n; i++) {
        jintArray i_tmp = (jintArray)((*env)->GetObjectArrayElement(env, ji_2a, i));
        jint * ji_tmp = (*env)->GetIntArrayElements(env, i_tmp, 0);
        for(j=0; j<n; j++) {
            imat[i][j] = ji_tmp[j];
        }
    }

    for(i=0; i<n; i++) {
       	jdoubleArray d_tmp = (jdoubleArray)((*env)->GetObjectArrayElement(env, jd_2a, i));
        jdouble * jd_tmp = (*env)->GetDoubleArrayElements(env, d_tmp, 0);
        for(j=0; j<n; j++) {
            dmat[i][j] = jd_tmp[j];
        }
    }

    // Zur Probe: Ausgabe einiger Daten
    printf("C: Inhalt des Integer Arrays, von Java uebergeben:\n");
    for (i=0; i<n; i++)
        printf("%2d %5d\n", i, i_a[i]);

    printf("C: Inhalt der 2-dim double-Matrix\n");
    for (i=0; i<n; i++) {
        for (j=0; j<n; j++) {
            printf("%5f   ", dmat[i][j]);
        }
        printf("\n");
    }

    printf("C: Inhalt der 2-dim int-Matrix\n");
    for (i=0; i<n; i++) {
        for (j=0; j<n; j++) {
            printf("%5d   ", imat[i][j]);
        }
        printf("\n");
    }

    printf("-- Aufruf des FORTRAN-Codes --\n");
    fcn_(&n, &jd, i_a, d_a, (int*)imat, (double*)dmat);
    printf("-- Zurueck im C-Programm --\n");

    printf("C: Inhalt des Integer-Arrays\n");
    for (i=0; i<n; i++)
       printf("%2d %5d\n", i, i_a[i]);

    printf("C: Inhalt der 2-dim double-Matrix\n");
    for (i=0; i<n; i++) {
        for (j=0; j<n; j++) {
            printf("%5f   ", dmat[i][j]);
        }
	    printf("\n");
    }
    printf("C: Inhalt der 2-dim int-Matrix\n");
    for (i=0; i<n; i++) {
        for (j=0; j<n; j++) {
            printf("%5d   ", imat[i][j]);
        }
	    printf("\n");
    }

    return;
}
