{******************************************************************************
 *  strings.pp - basic string functions
 *
 *
 *  Copyright (c) 2004 nucleOS Group [http://nucle-os.sourceforge.net/]
 *                                   [http://www.sf.net/projects/nucle-os]
 *                                   [http://www.saint-soft.de/nucleos/board/]
 *
 *  version 0.1 - 16/02/2004
 *
 *  written by
 *    Michael Ger"auser (saberrider) [saberrider@users.sourceforge.net]
 *
 *  This file contains basic string functions such as length, ord, chr, ...
 *
 * This program is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software Foundation
 * (version 2, June 1991)
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program; if not, write to:
 * Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330
 * Boston, MA 02111-1307 USA
 *
 ******************************************************************************}


unit strings;

interface

function IntToStr( value: LongInt ): String; external name 'INTTOSTR';
function IntToHex( value: LongInt ): String; external name 'INTTOSTR';

function length( value: String ): byte;
function Ord( value: char ): byte;
function Chr( value: byte ): char;
function UpperCase( value: String ): String;
function LowerCase( value: String ): String;
function UpCase( c: char ): char;
function LowCase( c: char ): char;

//function Format( value: String; args: array of const ): String;
// see below for reasons deactivating the format-function


implementation

{******************************************************************************
 *   length
 ******************************************************************************
 *  does:
 *   returns length of given string by just reading first byte of string
 ******************************************************************************}
function length( value: String ): byte; [public, alias : 'LENGTH_STR'];
var
   tmp: byte;
begin
     asm
        lea esi, [value]
        xor eax, eax
        mov al, [esi]
        mov tmp, al
     end;

     length := tmp;
end;

{******************************************************************************
 *   Ord
 ******************************************************************************
 *  does:
 *   return ASCII code of given char
 ******************************************************************************}
function Ord( value: char ): byte; [public, alias : 'ORD'];
var
   tmp: byte;
begin
     asm
        xor eax, eax
        lea esi, [value]
        lodsb
        mov tmp, al
     end;

     ord := tmp;
end;

{******************************************************************************
 *   Chr
 ******************************************************************************
 *  does:
 *   return Char of given ASCII code
 ******************************************************************************}
function Chr( value: byte ): char; [public, alias : 'CHR'];
var
   tmp: char;
begin
     asm
        xor eax, eax
        lea esi, [value]
        lodsb
        mov tmp, al
     end;

     chr := tmp;
end;

{******************************************************************************
 *   UpperCase
 ******************************************************************************
 *  does:
 *   converts all [a..z] to [A..Z]
 ******************************************************************************}
function UpperCase( value: String ): String; [public, alias:'UPPERCASE'];
var
   i: byte;
begin
     for i := 1 to Length( value ) do
     begin
         	if (ord( value[i] ) > 96) and (ord( value[i] ) < 123) then
         	   value[i] := chr( ord( value[i] ) - 32 );
     end;
     UpperCase := value;
end;

{******************************************************************************
 *   LowerCase
 ******************************************************************************
 *  does:
 *   converts all [A..Z] to [a..z]
 ******************************************************************************}
function LowerCase( value: String ): String; [public, alias:'LOWERCASE'];
var
   i: byte;
begin
     for i := 1 to Length( value ) do
     begin
         	if (ord( value[i] ) > 64) and (ord( value[i] ) < 91) then
         	   value[i] := chr( ord( value[i] ) + 32 );
     end;
     LowerCase := value;
end;

{******************************************************************************
 *   UpCase
 ******************************************************************************
 *  does:
 *   converts a single char from lower to upper case
 ******************************************************************************}
function UpCase( c: char ): char; [public, alias:'UPCASE'];
begin
   	 if (ord( c ) > 96) and (ord( c ) < 123) then
        c := chr( ord( c ) - 32 );

     UpCase := c;
end;

{******************************************************************************
 *   LowCase
 ******************************************************************************
 *  does:
 *   converts a single char from upper to lower case
 ******************************************************************************}
function LowCase( c: char ): char; [public, alias:'LOWCASE'];
begin
   	 if (ord( c ) > 64) and (ord( c ) < 91) then
        c := chr( ord( c ) + 32 );

     LowCase := c;
end;

{
  implemented formatstrings:
     %s: insert substring
     %i: insert integer
     %h: insert hexcode from integer
}

{
  the reason this function is deactivated currently is that it requires
  "array of const" which requires OOP class TVarRec. Integrating
  FPC's OOP requires memory manager functions like sbrk, GetMem,
  FreeMem. Since we don't have a memory manager yet, we'll have
  to wait a moment...

  saberrider
}

{function Format( value: String; args: array of const ): String; [public, alias:'FORMAT'];
var
   i: byte;
   c: char;
   cur_arg: Integer;
   tmp: String;
begin
     cur_arg := 0;
     tmp := '';

     for i := 1 to Length( value ) do
     begin
         	c := value[i];
         	if c <> '%' then
         	   tmp := tmp + c
         	else
         	begin
         	    	i := i + 1;
         	    	c := value[i];
         	    	case c of
         	    	's': tmp := tmp + args[cur_arg].VString^;
         	    	'i':
                     begin
                         	tmp := tmp + IntToStr(args[cur_arg].VInteger);
                         	cur_arg := cur_arg + 1;
                     end;
                     'h':
                     begin
                         	tmp := tmp + IntToHex(args[cur_arg].VInteger);
                         	cur_arg := cur_arg + 1;
                     end;
                     end;
            end;
     end;

//     format := tmp;
end;}


begin
end.
