{****************************************************************************************
 * gfxdrvUnit.pp - The unit where all procedures for our graphics driver are 		*
 *		   implemented								*
 *											*
 * written by Bastian Gloeckle (MrSaint), programmer of nucleOS				*
 *											*
 * Copyright (C) 2004 by nucleOS group							*
 *											*
 * This program is free software; you can redistribute it and/or modify it under the	*
 * terms of the GNU General Public License as published by the Free Software Foundation	*
 * (version 2, June 1991)								*
 *											*
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY	*
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A	*
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.		*
 *											*
 * You should have received a copy of the GNU General Public License along with this	*
 * program; if not, write to: 								*
 * Free Software Foundation, Inc.							*
 * 59 Temple Place, Suite 330								*
 * Boston, MA 02111-1307 USA								*
 *											*
 *											*
 * You can contact me by electronic mail: admin@saint-soft.de				*
 ****************************************************************************************}
unit GfxDrvUnit;

interface

procedure GFXDRVwrite(x,y,attribute: byte);
procedure GFXDRVSetCursorPos(x,y: byte);
procedure GFXDRVScrollOneLine;

var 
  bGFXDRVCurrentX: byte; cvar;
  bGFXDRVCurrentY: byte; cvar;


implementation



{........................................................
 Writes a string to the screen

 INPUT:
	FS:ESI = adress of the string
 ........................................................}
procedure GFXDRVwrite(x,y,attribute: byte); [public, alias: 'GFXDRVWRITE'];
begin
  asm
	push edi
	push es
	push ebx
	push edx
	push ecx
	push eax
	cld
	mov ax, $10
	mov es, ax
	xor eax, eax			// be sure eax is clear
	mov al, [y]			// calculate: 0B8000h + ([row] * 80 + [col]) * 2
	imul eax, 80
	xor edx, edx
	mov dh, [x]
	add eax, edx			// add column value
	shl eax, 1			// *2
	add eax, $B8000
	mov edi, eax			// copy to destination-indexregister
	push ds
	push fs
	pop ds
	lodsb
	pop ds
	xor ecx, ecx
	mov cl, al
	@entry:
		push ds			// save ds
		push fs			// set ds = fs (out string is at FS:ESI)
		pop ds
		lodsb			// load one byte from DS:ESI to AL
		pop ds			// restore our saved ds
		mov es:[edi], al	// move character byte to video buffer
		mov eax, edi		// edi = edi + 1
		inc eax
		mov edi, eax
		mov al, [attribute]
		mov es:[edi], al	// move attribute to video buffer
		mov eax, edi		// edi = edi + 1
		inc eax
		mov edi, eax
		loop @entry
	pop eax
	pop ecx
	pop edx
	pop ebx
	pop es
	pop edi
  end;
end;



{ ........................................................
  sets the cursor position
  ........................................................}
procedure GFXDRVSetCursorPos(x,y: byte); [public, alias: 'GFXDRVSETCURSORPOS'];
begin
  asm
	cli
	push eax
	push edx
	push ebx				{ calculate "absolute" adress (out of row+column) }
	xor ebx, ebx
	mov bl, [y]				{ calc line number * 80 (beacause every line has 80 columns) }
	imul bx, 80
	xor eax, eax
	mov al, [x]
	add bx, ax				{ add column -> BX = "absolute" adress }

	mov al, 14				{ say to CRT controller: We want to set the higher bits of cursor position }
	mov dx, 03D4h
	out dx, al
	mov ax, bx
	mov dx, 03D5h
	xchg al, ah				{ so we have higher bits in al! }
	out dx, al				{ set it }

	mov al, 15				{ say to CRT controller: We want to set the lower bits of cursor position }
	mov dx, 03D4h
	out dx, al
	mov ax, bx
	mov dx, 03D5h
	out dx, al				{ set it }

	pop ebx
	pop edx
	pop eax
	sti
  end;
end;

{ ........................................................
  scrolls the content of the screen one line down
  ........................................................}
procedure GFXDRVScrollOneLine; [public, alias: 'GFXDRVSCROLLONELINE'];
begin
  asm
	push eax
	push es
	push esi
	push edi
	mov ax, 10h
	mov es, ax
	mov ecx, 3840			{ # of characters to copy (line 2-25) }
	mov esi, 0B80A0h		{ start at line 2 }
	mov edi, 0B8000h
	@loop_1:
		mov al, byte es:[esi]	{ copy one byte }
		mov es:[edi], al
		inc edi
		inc esi
		loop @loop_1
	dec edi
	mov ecx, 80			{ delete last line }
	@loop_2:
		mov word es:[edi], word $2007
		add edi, 2
		loop @loop_2
	pop edi
	pop esi
	pop es
	pop eax
  end;
end;


begin
  bGFXDRVCurrentX := 0;
  bGFXDRVCurrentY := 0;
end.
